%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
% Lauwerier 1954 - Linear flow                                            %
%                                                                         %
% Version July 2013           Nelson Molina-Giraldo Matrix Solutions Inc. %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function T = T_lauw_linear(r,z,h,lm,lm2,Cw,Cm,Cm2,vT,t,Q,ax)
%--Analytical solution----------------------------------------------------%
x = r;
v = vT*Cm/Cw;
E = 4*lm2*x/h^2/Cw/v;
n = 2*z/h;
tao = 4*lm2*t/h^2/Cm;
the = Cm/Cm2;
T = erfc((E+abs(n)-1)/2./sqrt(the*abs(tao-E)));
T(tao - E <= 0) = 0;

% r : radial coordinate [m]
% h : aqufer thickness [m]
% uz : thickness of the overlaying layer [m]
% k : bulk thermal conductivity of the aquifer [W/m/K]
% kd : bulk thermal conductivity of the overlaying layer [W/m/K]
% t : simulation time [s]
% vhcw : volumetric heat capacity of the water [J/m^3/K]
% vhcm : volumetric heat capacity of the porous medium (aquifer) [J/m^3/K]
% vhcmd : volumetric heat capacity of the porous medium (confining layers) [J/m^3/K]
% vT : heat transport velocity [m/s]
% ax: longitudinal thermal dispersivity
% Q : injection rate [m^3/s]
